import { Router } from 'express';
import { UserController } from './controllers/UserController';

const router = Router();

router.get('/users', async (req, res) => {
  const users = await new UserController(new UserRepository()).getAllUsers();
  res.json(users);
});

router.get('/users/:id', async (req, res) => {
  const id = req.params.id;
  const user = await new UserController(new UserRepository()).getUserById(id);
  res.json(user);
});

export default router;