package com.example;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FileController {

    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    @GetMapping("/files")
    public List<String> getFiles() {
        return fileService.getFiles();
    }

    @GetMapping("/files/{path}")
    public String getFileContent(@PathVariable String path) {
        return fileService.getFileContent(path);
    }
}