import { createServer } from 'http';
import express, { Request, Response } from 'express';
import { Container } from 'inversify';
import { Application } from './application';

const app = express();
const httpServer = createServer(app);

const container = new Container();
const application = new Application(container);

application.bindDependencies();
application.boot();

httpServer.listen(3000, () => {
  console.log('Server is listening on port 3000');
});