# Clean Architecture Project

## Overview
This project follows the clean architecture principles to separate the application logic into layers.

## Architecture
The project consists of the following layers:

### Entities
This layer contains the business domain models.

### Use Cases
This layer contains the use cases that define the interactions between the user and the system.

### Interface Adapters
This layer contains the interfaces to the outside world, such as databases, file systems, and networks.

### Frameworks and Drivers
This layer contains the frameworks and drivers that are used to interact with the outside world.

### Infrastructure
This layer contains the infrastructure components, such as databases and file systems.

## Dependencies
The project uses the following dependencies:

* Java 11
* Spring Boot 2.5.3
* Maven 3.6.3

## Setup
To set up the project, follow these steps:

1. Clone the repository using Git.
2. Import the project into your IDE.
3. Run the application using Maven.

## Running the Application
To run the application, follow these steps:

1. Navigate to the project directory.
2. Run the command `mvn spring-boot:run`.
3. The application will start and be available at `http://localhost:8080`.

## Testing the Application
To test the application, follow these steps:

1. Navigate to the project directory.
2. Run the command `mvn test`.
3. The tests will run and report any errors.

## Contributing
To contribute to the project, follow these steps:

1. Fork the repository.
2. Create a new branch for your feature or bug fix.
3. Commit your changes and push them to the remote repository.
4. Create a pull request to merge your changes into the main branch.

## License
This project is licensed under the MIT License.

## Acknowledgments
This project was inspired by the clean architecture principles and the Spring Boot framework.
