// Import the repository interface
import { Repository } from '../interfaces/repository';

// Import the entity interface
import { Entity } from '../interfaces/entity';

// Define the user use case
class UserUseCase implements UseCase<Entity> {
  private repository: Repository<Entity>;

  constructor(repository: Repository<Entity>) {
    this.repository = repository;
  }

  async execute(): Promise<Entity> {
    return this.repository.create({ name: 'John Doe' });
  }
}

// Export the user use case
export { UserUseCase };