// Import the typeorm module
import { getRepository } from 'typeorm';

// Import the entity interface
import { Entity } from '../interfaces/entity';

// Define the user repository
class UserRepository implements Repository<Entity> {
  private repository: any;

  constructor() {
    this.repository = getRepository(Entity);
  }

  async findAll(): Promise<Entity[]> {
    return this.repository.find();
  }

  async findById(id: number): Promise<Entity | null> {
    return this.repository.findOne(id);
  }

  async create(entity: Entity): Promise<Entity> {
    return this.repository.save(entity);
  }

  async update(id: number, entity: Entity): Promise<Entity> {
    return this.repository.save(entity);
  }

  async delete(id: number): Promise<void> {
    await this.repository.delete(id);
  }
}

// Export the user repository
export { UserRepository };