import { routes } from './presentation/routes';
import { createServer } from 'http';

const server = createServer((req, res) => {
  const route = routes.find((route) => route.path === req.url);
  if (route) {
    route.handler(req, res);
  } else {
    res.writeHead(404, {
      'Content-Type': 'text/plain',
    });
    res.end('Not Found');
  }
});

server.listen(3000, () => {
  console.log('Server listening on port 3000');
});