// Import the use case interface
import { UseCase } from '../interfaces/usecase';

// Import the entity interface
import { Entity } from '../interfaces/entity';

// Define the user controller
class UserController implements Controller<Entity> {
  private useCase: UseCase<Entity>;

  constructor(useCase: UseCase<Entity>) {
    this.useCase = useCase;
  }

  async handleRequest(request: Request, response: Response): Promise<void> {
    const entity = await this.useCase.execute();
    response.send(entity);
  }
}

// Export the user controller
export { UserController };