// Import the typeorm module
import { createConnection } from 'typeorm';

// Define the database connection options
const connectionOptions = {
  type: 'mysql',
  host: process.env.DB_HOST,
  port: parseInt(process.env.DB_PORT),
  username: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
};

// Create the database connection
createConnection(connectionOptions).then((connection) => {
  console.log('Database connection established');
}).catch((error) => {
  console.log('Error establishing database connection:', error);
});