const path = require('path');
const webpack = require('webpack');
const BabelLoader = require('./utils/loaders').createBabelLoader;

module.exports = {
  entry: './src/index.js',
  output: {
    path: path.resolve(__dirname, 'public'),
    filename: 'bundle.js',
  },
  module: {
    rules: [
      {
        test: /.js$/,
        use: [BabelLoader()],
        exclude: /node_modules/,
      },
    ],
  },
  devServer: {
    contentBase: path.resolve(__dirname, 'public'),
    compress: true,
    port: 3000,
  },
};