import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class RssService {
    public List<NewsArticle> getNewsArticles(String rssFeedUrl) throws Exception {
        // Download RSS feed
        String rssFeed = downloadRssFeed(rssFeedUrl);

        // Parse RSS feed
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(rssFeed));
        Document document = builder.parse(is);

        // Extract news articles
        NodeList items = document.getElementsByTagName("item");
        List<NewsArticle> newsArticles = new ArrayList<>();

        for (int i = 0; i < items.getLength(); i++) {
            Element item = (Element) items.item(i);

            String title = item.getElementsByTagName("title").item(0).getTextContent();
            String description = item.getElementsByTagName("description").item(0).getTextContent();
            String link = item.getElementsByTagName("link").item(0).getTextContent();

            // Parse published date
            String publishedDate = item.getElementsByTagName("pubDate").item(0).getTextContent();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z");
            LocalDateTime published = LocalDateTime.parse(publishedDate, formatter);

            newsArticles.add(new NewsArticle(title, description, link, published));
        }

        return newsArticles;
    }

    private String downloadRssFeed(String rssFeedUrl) throws Exception {
        // Implement RSS feed download logic here
        return "<rss><channel><item><title>Article 1</title><description>This is article 1</description><link>https://example.com/article1</link><pubDate>Mon, 01 Jan 2024 12:00:00 +0000</pubDate></item></channel></rss>";
    }
}