import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.List;

@RestController
public class RssController {
    private final RssService rssService;

    public RssController(RssService rssService) {
        this.rssService = rssService;
    }

    @GetMapping("/rss")
    public String getRssFeed() throws Exception {
        List<NewsArticle> newsArticles = rssService.getNewsArticles("https://example.com/rss-feed");

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject jsonObject = new JsonObject();
        JsonElement jsonElement = gson.toJsonTree(newsArticles);
        jsonObject.add("newsArticles", jsonElement);

        return gson.toJson(jsonObject);
    }
}