package com.example.usecase;

import com.example.domain.User;

import com.example.repository.UserRepository;

public class UserUseCase {

    private final UserRepository userRepository;

    public UserUseCase(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public User getUser(String id) {
        return userRepository.getUser(id);
    }

    public void saveUser(User user) {
        userRepository.saveUser(user);
    }

}