import { UserRepository } from '../infrastructure/repositories/UserRepository';
import { User } from '../domain/entities/User';

export class CreateUserUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  async execute(name: string): Promise<User> {
    const user = new User('1', name);
    await this.userRepository.save(user);
    return user;
  }
}