// Config.java
// Load secrets/keys from properties file
import java.util.Properties;

public class Config {
    private static final String PROPERTIES_FILE = "application.properties";

    public static String getProperty(String key) {
        Properties properties = new Properties();
        try (InputStream inputStream = Config.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE)) {
            properties.load(inputStream);
            return properties.getProperty(key);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}