# Clean Architecture Project

## Overview
This project follows the clean architecture principles to separate concerns and make it easier to maintain and scale.

## Getting Started
To get started, run the following command:

```bash
npm install
npm run build
```

## Running the Application
To run the application, use the following command:

```bash
npm start
```

## Building the Application
To build the application, use the following command:

```bash
npm run build
```

## Testing the Application
To test the application, use the following command:

```bash
npm run test
```

## Project Structure
The project structure is as follows:

```bash
src/
├── main/
│   ├── application/
│   ├── domain/
│   ├── infrastructure/
│   └── presentation/
├── test/
│   ├── application/
│   ├── domain/
│   ├── infrastructure/
│   └── presentation/
└── package.json
```

## Clean Architecture Layers
The clean architecture layers are as follows:

### Domain Layer
The domain layer contains the business logic of the application.

### Infrastructure Layer
The infrastructure layer contains the implementation details of the application.

### Presentation Layer
The presentation layer contains the user interface of the application.

### Application Layer
The application layer contains the use cases of the application.
