// server.ts
import { createServer } from 'http';
import { createRouter } from './router';

export function createServer(): Promise<http.Server> {
  const server = createServer();
  const router = createRouter();
  server.on('request', router);
  return new Promise((resolve, reject) => {
    server.listen(0, () => {
      resolve(server);
    });
  });
}