# Clean Architecture Example

## Secrets and Configuration

This project uses a clean architecture approach to handle secrets and configuration.

### Secrets

The `Secrets` class in `src/main/java/com/example/config/Secrets.java` contains placeholder values for sensitive data.

### Configuration

The `Properties` class in `src/main/java/com/example/config/Properties.java` contains placeholder values for configuration properties.

### Environment Variables

The `application.properties` file in `src/main/resources` uses environment variables to replace placeholder values.

### Usage

To use this project, replace the placeholder values in `Secrets.java` and `Properties.java` with actual secrets and configuration properties.

### Example

```bash
mvn spring-boot:run -DDB_URL=jdbc:mysql://localhost:3306/db -DDB_USERNAME=myuser -DDB_PASSWORD=mypassword -DAPI_URL=https://api.example.com
```