export interface LoginUseCase {
  execute(username: string, password: string): Promise<User | null);
}

export class LoginUseCaseImpl implements LoginUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  async execute(username: string, password: string): Promise<User | null> {
    const user = await this.userRepository.findByUsername(username);
    if (user && user.getPassword() === password) {
      return user;
    }
    return null;
  }
}