# Clean Architecture Project

This is a clean architecture project template.

## Table of Contents

* [Overview](#overview)
* [Getting Started](#getting-started)
* [Architecture](#architecture)
* [Development](#development)
* [Testing](#testing)
* [Deployment](#deployment)

## Overview

This project follows the clean architecture principles.

## Getting Started

### Prerequisites

* Java 11 or higher
* Maven 3.6 or higher

### Installation

1. Clone the repository
2. Run `mvn clean install` to build the project
3. Run `mvn spring-boot:run` to start the application

## Architecture

The project follows the clean architecture principles, with the following layers:

* **Entities**: Represent the business domain
* **Use Cases**: Define the business logic
* **Interface Adapters**: Define the interfaces to the outside world
* **Frameworks and Drivers**: Define the interfaces to the frameworks and drivers
* **Infrastructure**: Define the infrastructure

## Development

### Tools

* Java 11 or higher
* Maven 3.6 or higher
* Spring Boot 2.5 or higher

### Best Practices

* Follow the clean architecture principles
* Use dependency injection
* Use interfaces instead of concrete classes

## Testing

### Unit Tests

* Use JUnit 5 or higher
* Use Mockito 3 or higher

### Integration Tests

* Use JUnit 5 or higher
* Use Spring Boot Test

## Deployment

### Docker

* Use Docker 20 or higher
* Use Docker Compose 1.25 or higher
