import { Request, Response } from 'express';
import { LoginUseCase } from '../use-cases/Login';

export class LoginController {
  private loginUseCase: LoginUseCase;

  constructor(loginUseCase: LoginUseCase) {
    this.loginUseCase = loginUseCase;
  }

  async handle(req: Request, res: Response): Promise<void> {
    const username = req.body.username;
    const password = req.body.password;
    const user = await this.loginUseCase.execute(username, password);
    if (user) {
      res.json({ user });
    } else {
      res.status(401).json({ error: 'Invalid credentials' });
    }
  }
}