const logger = require('../utils/logger');
const userService = require('../services/user.service');

class UserController {
  async getAllUsers(req, res) {
    try {
      const users = await userService.getAllUsers();
      res.json(users);
    } catch (error) {
      logger.error(error);
      res.status(500).json({ message: 'Error fetching users' });
    }
  }

  async createUser(req, res) {
    try {
      const user = await userService.createUser(req.body);
      res.json(user);
    } catch (error) {
      logger.error(error);
      res.status(500).json({ message: 'Error creating user' });
    }
  }

  async getUserById(req, res) {
    try {
      const user = await userService.getUserById(req.params.id);
      res.json(user);
    } catch (error) {
      logger.error(error);
      res.status(500).json({ message: 'Error fetching user' });
    }
  }
}

module.exports = UserController;