const express = require('express');
const app = express();
const userRoute = require('./routes/user.route');
const userController = require('./controllers/user.controller');
const userModel = require('./models/user.model');
const userService = require('./services/user.service');
const logger = require('./utils/logger');

app.use(express.json());
app.use('/users', userRoute);

app.listen(3000, () => {
  logger.info('Server listening on port 3000');
});

module.exports = app;