// Import required modules
import { PricingTierRepository } from '../data-access/PricingTierRepository';

// Define the usePricingTiers hook
const usePricingTiers = () => {
  const pricingTiers = useQuery(
    ['pricingTiers'],
    async () => {
      const pricingTierRepository = new PricingTierRepository();
      return pricingTierRepository.getPricingTiers();
    }
  );

  return pricingTiers;
};

// Export the usePricingTiers hook
export { usePricingTiers };
