// Import required modules
import React from 'react';
import { PricingTierSelector } from './PricingTierSelector';

// Define the PricingTierSelector component
const PricingTierSelectorComponent: React.FC = () => {
  // Define the pricing tiers
  const pricingTiers = [
    { id: 1, name: 'Free', price: 0 },
    { id: 2, name: 'Basic', price: 9.99 },
    { id: 3, name: 'Premium', price: 19.99 }
  ];

  // Handle tier selection
  const handleTierSelection = (tier: { id: number; name: string; price: number }) => {
    console.log(`Selected tier: ${tier.name}`);
  };

  // Render the pricing tier selector
  return (
    <PricingTierSelector
      pricingTiers={pricingTiers}
      onTierSelection={handleTierSelection}
    />
  );
};

// Export the PricingTierSelector component
export { PricingTierSelectorComponent as PricingTierSelector };
