import { CreateUserUseCase } from '../application/use-cases/CreateUserUseCase';
import { Request, Response } from 'express';

export class CreateUserController {
  private createUserUseCase: CreateUserUseCase;

  constructor(createUserUseCase: CreateUserUseCase) {
    this.createUserUseCase = createUserUseCase;
  }

  async handle(request: Request, response: Response): Promise<void> {
    const user = {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com',
    };

    await this.createUserUseCase.execute(user);

    response.status(201).send({ message: 'User created successfully' });
  }
}
