import { User } from '../domain/entities/User';

export class UserRepository {
  private users: User[];

  constructor() {
    this.users = [];
  }

  async getAllUsers(): Promise<User[]> {
    return this.users;
  }

  async getUserById(id: string): Promise<User | null> {
    return this.users.find((user) => user.id === id) || null;
  }

  async createUser(user: User): Promise<void> {
    this.users.push(user);
  }
}
