import { UserRepository } from '../infrastructure/repositories/UserRepository';
import { User } from '../domain/entities/User';

export class CreateUserUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  async execute(user: User): Promise<void> {
    await this.userRepository.createUser(user);
  }
}
