# Clean Architecture Node.js Project

This is a basic Node.js project following the clean architecture principles.

## Getting Started

1. Install dependencies: `npm install`
2. Start the server: `node src/index.js`

## Project Structure

* `src/`: Source code
* `src/index.js`: Entry point
* `src/controllers/`: Business logic
* `src/models/`: Data models
* `src/repositories/`: Data access layer
* `src/services/`: Services
* `src/utils/`: Utilities

## Commit Messages

Follow the conventional commit message format:

* feat: A new feature
* fix: A bug fix
* docs: Changes to documentation
* style: Changes to code style
* refactor: A code change that neither fixes a bug nor adds a feature
* perf: A change that improves performance
* test: Adding missing tests or correcting existing ones
* chore: Changes to build or auxiliary tools and libraries such as documentation generation
