import { User } from '../entities/user.entity';
import { LoginRequest } from '../interfaceAdapters/login.request';

export class LoginUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public async execute(request: LoginRequest): Promise<User> {
    const user = await this.userRepository.findByEmail(request.email);
    if (!user) {
      throw new Error('User not found');
    }
    if (!user.password.equals(request.password)) {
      throw new Error('Invalid password');
    }
    return user;
  }
}
