import { LoginController } from './interfaceAdapters/login.controller';
import { LoginUseCase } from './useCases/login.useCase';
import { UserRepository } from './frameworksAndDrivers/user.repository';

const loginController = new LoginController(new LoginUseCase(new UserRepository()));

const app = express();
app.post('/login', loginController.login);
app.listen(3000, () => {
  console.log('Server started on port 3000');
});
