import { LoginUseCase } from '../useCases/login.useCase';
import { LoginRequest } from '../interfaceAdapters/login.request';

export class LoginController {
  private loginUseCase: LoginUseCase;

  constructor(loginUseCase: LoginUseCase) {
    this.loginUseCase = loginUseCase;
  }

  public async login(request: LoginRequest): Promise<User> {
    return this.loginUseCase.execute(request);
  }
}
