# Clean Architecture Project

## Overview

This project follows the clean architecture principles to separate the application logic into layers.

## Architecture

### Domain Layer

The domain layer contains the business logic of the application. It includes the entities, use cases, and interfaces.

### Infrastructure Layer

The infrastructure layer contains the implementation details of the application. It includes the data access objects, repositories, and services.

### Presentation Layer

The presentation layer contains the user interface of the application. It includes the controllers, views, and routes.

## Technologies Used

* Java 11
* Spring Boot 2.5
* Maven

## Setup

1. Clone the repository using `git clone https://github.com/username/repository.git`
2. Navigate to the project directory using `cd repository`
3. Run `mvn clean install` to build the project
4. Run `mvn spring-boot:run` to start the application

## API Documentation

The API documentation can be found at `http://localhost:8080/swagger-ui.html`

## Commit Messages

* Use the present tense (e.g. 'Add feature' instead of 'Added feature')
* Use the imperative mood (e.g. 'Fix bug' instead of 'Fixes bug')
* Keep the message concise and descriptive

## Code Conventions

* Follow the Java Code Conventions
* Use meaningful variable names and method names
* Use comments to explain complex logic

## Testing

* Unit tests should cover at least 80% of the code
* Integration tests should cover at least 50% of the code
* Use mocking libraries to isolate dependencies

## Contributing

* Fork the repository and create a new branch
* Make changes and commit them
* Submit a pull request with a clear description of the changes

## License

This project is licensed under the MIT License

## Acknowledgments

* [Name] for contributing to the project
