# Clean Architecture Project

## Overview
This project follows a clean architecture pattern, separating the application logic into layers. The architecture is designed to be modular, scalable, and maintainable.

## Environment Variables
The following environment variables are required:

* `DB_HOST`: The hostname or IP address of the database server.
* `DB_PORT`: The port number of the database server.
* `DB_NAME`: The name of the database.
* `DB_USER`: The username to use when connecting to the database.
* `DB_PASSWORD`: The password to use when connecting to the database.

## Install Steps
To install the project, run the following commands:

```bash
npm install
```

## Build Commands
To build the project, run the following commands:

```bash
npm run build
```

## Deployment Instructions
To deploy the project, run the following commands:

```bash
npm run deploy
```

## Architecture Diagram
The following diagram illustrates the architecture of the project:

```plantuml
@startuml
  participant User
  participant Controller
  participant Service
  participant Repository
  participant Database
  User ->> Controller: Request
  Controller ->> Service: Request
  Service ->> Repository: Request
  Repository ->> Database: Request
  Database ->> Repository: Response
  Repository ->> Service: Response
  Service ->> Controller: Response
  Controller ->> User: Response
@enduml
```

## Clean Architecture Layers
The project is organized into the following layers:

* **Presentation Layer**: Handles user input and output.
* **Application Layer**: Contains the business logic of the application.
* **Domain Layer**: Represents the core business domain.
* **Infrastructure Layer**: Handles data storage and retrieval.

## Dependencies
The project depends on the following packages:

* `express`: A Node.js web framework.
* `typeorm`: An ORM for interacting with the database.
* `dotenv`: A package for loading environment variables from a `.env` file.
