# Clean Architecture Project

## Overview
This project follows the clean architecture principles to separate the application logic into layers.

## Layers
### Entities
- Define business domain models.
### Use Cases
- Define application use cases.
### Interface Adapters
- Define interfaces for data sources and presentation.
### Frameworks and Drivers
- Implement frameworks and drivers for data sources and presentation.
### Entities
- Implement business domain models.
### Use Cases
- Implement application use cases.
### Interface Adapters
- Implement interfaces for data sources and presentation.
### Frameworks and Drivers
- Implement frameworks and drivers for data sources and presentation.

## Actions Taken
- Separated application logic into layers.
- Implemented entities, use cases, interface adapters, and frameworks and drivers.

## Next Steps
- Implement data sources and presentation.
- Test and refine the application.