# Server Documentation

## REST Endpoints

### GET /endpoints

Returns a list of available REST endpoints.

### POST /endpoints

Creates a new REST endpoint.

### PUT /endpoints/:id

Updates an existing REST endpoint.

### DELETE /endpoints/:id

Deletes a REST endpoint.

## Example Use Cases

* Use the GET /endpoints endpoint to retrieve a list of available REST endpoints.
* Use the POST /endpoints endpoint to create a new REST endpoint.
* Use the PUT /endpoints/:id endpoint to update an existing REST endpoint.
* Use the DELETE /endpoints/:id endpoint to delete a REST endpoint.

## API Documentation

### GET /endpoints

* **Request**: `GET /endpoints`
* **Response**: `200 OK` with a list of available REST endpoints.
* **Request Body**: None
* **Response Body**: JSON object containing a list of available REST endpoints.

### POST /endpoints

* **Request**: `POST /endpoints` with a JSON object containing the endpoint details.
* **Response**: `201 Created` with the created endpoint details.
* **Request Body**: JSON object containing the endpoint details.
* **Response Body**: JSON object containing the created endpoint details.

### PUT /endpoints/:id

* **Request**: `PUT /endpoints/:id` with a JSON object containing the updated endpoint details.
* **Response**: `200 OK` with the updated endpoint details.
* **Request Body**: JSON object containing the updated endpoint details.
* **Response Body**: JSON object containing the updated endpoint details.

### DELETE /endpoints/:id

* **Request**: `DELETE /endpoints/:id`
* **Response**: `204 No Content`.
