import { createStore } from 'redux';
import { CounterAction } from '../types';
import { useCounter } from '../hooks';

const initialState: CounterState = {
  count: 0,
};

const counterReducer = (state = initialState, action: CounterAction) => {
  switch (action.type) {
    case 'INCREMENT':
      return {
        ...state,
        count: state.count + 1,
      };
    case 'DECREMENT':
      return {
        ...state,
        count: state.count - 1,
      };
    default:
      return state;
  }
};

const store = createStore(counterReducer);

export default store;