import express, { Request, Response } from 'express';
import { UserRepository } from '../infrastructure/repositories/UserRepository';

export class AppRouter {
  private router: express.Router;
  private userRepository: UserRepository;

  constructor() {
    this.router = express.Router();
    this.userRepository = new UserRepository();
  }

  get router(): express.Router {
    return this.router;
  }

  async handleGetUsers(req: Request, res: Response): Promise<void> {
    const users = await this.userRepository.findAll();
    res.json(users);
  }

  configureRoutes(): void {
    this.router.get('/users', this.handleGetUsers.bind(this));
  }
}