import express from 'express';
import { createServer } from 'http';
import { Server, Socket } from 'socket.io';

const app = express();
const server = createServer(app);
const io = new Server(server);

app.get('/', (req, res) => {
  res.send('Hello World!');
});

io.on('connection', (socket: Socket) => {
  console.log('a client connected');
});

server.listen(3000, () => {
  console.log('listening on *:3000');
});