# Analyze requirements

You are an autonomous principal engineer. Build a complete React + Node.js application that fulfills the user request.

User request:
Build fish catalog explorer

Delivery checklist:
- Produce a multi-workspace repository with at least `client/` (React + Vite/Next) and `server/` (Node/Express) directories.
- Each workspace must ship with package.json scripts for dev/build/start plus any required TypeScript configs.
- Include `README.md` describing architecture, environment variables, install steps, build commands, and deployment instructions.
- Provide realistic fixture data (JSON/seed) so the experience works without live APIs.
- Document and expose REST endpoints (e.g., `/api/...`) inside the server along with request/response examples.
- Provide an `.env.example` (or similar) enumerating all secrets/keys with safe placeholder values.
- If a frontend build step is needed, include a prebuilt `dist/` folder or at minimum `npm run build` instructions.
- Instrument the project with clear file organization, comments where necessary, and opinionated formatting.

## Trend Snapshot (latest 6 months)
| Month | Avg Price | Δ |
| --- | --- | --- |
| 2025-01 | $2,066.69 | +0.00 |
| 2025-02 | $2,085.51 | +18.82 |
| 2025-03 | $2,108.51 | +23.00 |
| 2025-04 | $2,133.96 | +25.45 |
| 2025-05 | $2,159.72 | +25.76 |
| 2025-06 | $2,183.64 | +23.92 |

## Insights
- Average trailing 12-month price: $2,174.02
- Year-over-year delta: +165.31 (upward trend)
- Best performing month: 2025-10
- Worst performing month: 2025-01