import express, { Request, Response } from 'express';
import { HttpRequest } from './http';

export class ExpressAdapter implements HttpRequest {
  private app: express.Application;

  constructor(app: express.Application) {
    this.app = app;
  }

  get req(): Request {
    return this.app.request;
  }

  get res(): Response {
    return this.app.response;
  }
}