const express = require('express');
const app = express();
const fs = require('fs');

app.get('/api/files', (req, res) => {
  const files = fs.readdirSync('./src').map(file => ({
    path: `src/${file}`,
    content: fs.readFileSync(`src/${file}`, 'utf8')
  }));
  res.json({ files });
});

app.get('/api/files/:path', (req, res) => {
  const filePath = req.params.path;
  try {
    const content = fs.readFileSync(filePath, 'utf8');
    res.json({ path: filePath, content });
  } catch (err) {
    res.status(404).json({ message: 'File not found' });
  }
});

app.post('/api/files', (req, res) => {
  const { path, content } = req.body;
  fs.writeFileSync(path, content);
  res.json({ path, content });
});

app.put('/api/files/:path', (req, res) => {
  const filePath = req.params.path;
  const { content } = req.body;
  fs.writeFileSync(filePath, content);
  res.json({ path: filePath, content });
});

app.delete('/api/files/:path', (req, res) => {
  const filePath = req.params.path;
  fs.unlinkSync(filePath);
  res.json({ message: 'File deleted successfully' });
});

app.listen(3000, () => {
  console.log('Server listening on port 3000');
});