import { Controller } from './controller';
import { HttpRequest } from '../ports/http';

export interface Gateway {
  handle(httpRequest: HttpRequest): string;
}

export class DefaultGateway implements Gateway {
  private controller: Controller;

  constructor(controller: Controller) {
    this.controller = controller;
  }

  handle(httpRequest: HttpRequest): string {
    return this.controller.handle(httpRequest);
  }
}