import { UseCase } from './usecase';
import { HttpRequest } from '../ports/http';

export interface Controller {
  handle(httpRequest: HttpRequest): string;
}

export class DefaultController implements Controller {
  private useCase: UseCase;

  constructor(useCase: UseCase) {
    this.useCase = useCase;
  }

  handle(httpRequest: HttpRequest): string {
    return this.useCase.execute(httpRequest);
  }
}