import { Container } from 'typescript-ioc';
import { DefaultGateway } from './interfaces/gateway';
import { DefaultController } from './interfaces/controller';
import { HelloWorldUseCase } from './usecases/hello-world';

const container = new Container();
container.bind(DefaultGateway).toSelf();
container.bind(DefaultController).toSelf();
container.bind(HelloWorldUseCase).toSelf();

const gateway = container.get(DefaultGateway);
const controller = container.get(DefaultController);
const useCase = container.get(HelloWorldUseCase);

controller.useCase = useCase;

const gatewayInstance = new DefaultGateway(controller);

export { gatewayInstance as gateway }