import { User } from '../entities/User';

export class CreateUserUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public execute(id: string, name: string): User {
    const user = new User(id, name);
    this.userRepository.save(user);
    return user;
  }
}