// Import required modules
import { createExpressServer } from 'routing-controllers';
import { createConnection } from 'typeorm';

// Create TypeORM connection
createConnection({
  type: 'postgres',
  host: process.env.DB_HOST,
  port: parseInt(process.env.DB_PORT),
  username: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
}).then(() => {
  // Create Express server
  const app = createExpressServer({
    controllers: [/* controllers */],
  });

  // Start the server
  app.listen(3000, () => {
    console.log('Server started on port 3000');
  });
}).catch((error) => {
  console.error('Error creating database connection:', error);
});