import { Request, Response } from 'express';
import { UserService } from '../services/UserService';

export class UserController {
  private userService: UserService;

  constructor(userService: UserService) {
    this.userService = userService;
  }

  public async getUser(req: Request, res: Response) {
    const user = await this.userService.getUser();
    res.json(user);
  }
}
