// Import required modules
import express from 'express';
import { createServer } from 'http';
import { Server } from 'socket.io';

// Create Express app
const app = express();

// Create HTTP server
const server = createServer(app);

// Create Socket.IO server
const io = new Server(server);

// Use Express middleware
app.use(express.json());

// Define API endpoints
app.get('/', (req, res) => {
  res.send('Hello World!');
});

// Start server
server.listen(3000, () => {
  console.log('Server listening on port 3000');
});

// Handle client connections
io.on('connection', (socket) => {
  console.log('Client connected');
});

// Handle client disconnections
io.on('disconnect', () => {
  console.log('Client disconnected');
});
