import express, { Request, Response } from 'express';
import { createServer } from 'http';
import { join } from 'path';
import { fileSystem } from './fileSystem';

const app = express();
const server = createServer(app);

app.use(express.json());

app.get('/files', (req: Request, res: Response) => {
  const files = fileSystem.getFiles();
  res.json(files);
});

app.get('/files/:path', (req: Request, res: Response) => {
  const path = req.params.path;
  const file = fileSystem.getFile(path);
  if (file) {
    res.json(file);
  } else {
    res.status(404).json({ message: 'File not found' });
  }
});

app.post('/files', (req: Request, res: Response) => {
  const path = req.body.path;
  const content = req.body.content;
  fileSystem.createFile(path, content);
  res.json({ message: 'File created successfully' });
});

app.put('/files/:path', (req: Request, res: Response) => {
  const path = req.params.path;
  const content = req.body.content;
  fileSystem.updateFile(path, content);
  res.json({ message: 'File updated successfully' });
});

app.delete('/files/:path', (req: Request, res: Response) => {
  const path = req.params.path;
  fileSystem.deleteFile(path);
  res.json({ message: 'File deleted successfully' });
});

const port = 3000;
server.listen(port, () => {
  console.log(`Server listening on port ${port}`);
});
